/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.uploader;

import java.lang.reflect.Method;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import replicatorg.app.Base;

public abstract class AbstractFirmwareUploader {
    protected int serialSpeed;
    protected String serialName;
    protected String architecture;
    protected String source;

    public String getUploadInstructions() {
        return "Click the upload button to begin uploading the firmware.";
    }

    public void setPortName(String portName) {
        this.serialName = portName;
    }

    public void setSpeed(String speed) {
        this.serialSpeed = Integer.parseInt(speed);
    }

    public void setArch(String arch) {
        this.architecture = arch;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public abstract boolean upload();

    public static AbstractFirmwareUploader makeUploader(Node n) {
        String className = n.getAttributes().getNamedItem("class").getNodeValue();
        try {
            Class<?> uploaderClass = ClassLoader.getSystemClassLoader().loadClass(className);
            AbstractFirmwareUploader afu = (AbstractFirmwareUploader)uploaderClass.newInstance();
            NodeList nl = n.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Node p = nl.item(i);
                if (p.getNodeType() == 1) {
                    String propName = p.getNodeName();
                    String propValue = p.getTextContent();
                    String methodName = "set" + propName.substring(0, 1).toUpperCase() + propName.substring(1);
                    try {
                        Method m = uploaderClass.getMethod(methodName, String.class);
                        Object[] params = new Object[]{propValue};
                        m.invoke((Object)afu, params);
                    }
                    catch (NoSuchMethodException nsme) {
                        Base.logger.severe("Couldn't set property " + propName);
                    }
                }
                ++i;
            }
            return afu;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

